<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TransmissionBox extends Model 
{

    protected $table = 'transmission_boxes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function location()
    {
        return $this->belongsTo('CameraLocation', 'tbox_location_id');
    }

    public function driver()
    {
        return $this->belongsTo('Driver', 'driver_id');
    }

}